﻿# -*- coding: utf-8 -*-
from imports import *

class Changelog(Screen):

	def __init__(self, session):

		skin = """
		<screen name="Changelog" position="0,0" size="1280,720" title="MediaPortal Changelog" backgroundColor="transparent" flags="wfNoBorder">
		<ePixmap position="215,110" size="850,500" zPosition="0" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/images/MP_update.png" alphatest="on" />
		<widget name="mplog" position="287,240" size="720,320" font="mediaportal;22" valign="top" halign="left" backgroundColor="#00000000" transparent="1" zPosition="1" />
		</screen>"""

		self.skin = skin

		self["mplog"] = ScrollLabel()

		Screen.__init__(self, session)

		self["actions"]  = ActionMap(["MP_Actions"], {
			"cancel": self.cancel,
			"up" : self.pageUp,
			"down" : self.pageDown,
			"right" : self.pageDown,
			"left" : self.pageUp,
			"nextBouquet" : self.pageUp,
			"prevBouquet" : self.pageDown
		}, -1)

		self.onLayoutFinish.append(self.Finished)

	def Finished(self):
		sl = self["mplog"]
		sl.instance.setZPosition(1)
		url = "http://master.dl.sourceforge.net/project/e2-mediaportal/changelog"
		getPage(url, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.getlog).addErrback(self.dataError)

	def getlog(self, data):
		self["mplog"].setText(data)

	def dataError(self, error):
		printl(error,self,"E")

	def pageUp(self):
		self["mplog"].pageUp()

	def pageDown(self):
		self["mplog"].pageDown()

	def cancel(self):
		self.close(None)