//#include <linux/module.h>	/* Specifically, a module */
#include <linux/kernel.h>	/* We're doing kernel work */
//#include <linux/proc_fs.h>	/* Necessary because we use the proc fs */
//#include <asm/uaccess.h>	/* for copy_from_user */
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <linux/types.h>
#include <linux/init.h>
//#include <linux/ioctl.h>
#include <stdio.h>
#include <stdlib.h>
#include <linux/fs.h>
#include <linux/dvb/frontend.h>
//#include <linux/i2c.h>
#include <linux/i2c-dev.h>
#include <linux/i2o.h>
#include <linux/delay.h>
//#include <linux/time.h>
#include <asm-generic/errno.h>
#include <asm-generic/errno-base.h>
//#include <asm/system.h>
//#include <asm/io.h>

/*
 * konfetti 0.0.1
 */


enum cmds
{
	CMD_SET_VCO 	= 0x10,
	CMD_TUNEREQUEST = 0x11,
	CMD_MPEGCONFIG  = 0x13,
	CMD_TUNERINIT   = 0x14,
	CMD_BANDWIDTH   = 0x15,
	CMD_GETAGC  	= 0x19,
	CMD_LNBCONFIG   = 0x20,
	CMD_LNBSEND 	= 0x21,
	CMD_SET_TONEPRE = 0x22,
	CMD_SET_TONE	= 0x23,
	CMD_UPDFWVERS   = 0x35,
	CMD_TUNERSLEEP  = 0x36,
	CMD_AGCCONTROL  = 0x3b,
	CMD_MAX     	= 0xFF
};


struct firmware_cmd
{
	enum cmds id;	/* Unique firmware command */
	int len;	/* Commands args len + id byte */
}; 

enum ufs910_COMMANDS
{
	CMDL_SET_VCO 	= 0x0A, 
	CMDL_TUNEREQUEST = 0x13,
	CMDL_MPEGCONFIG  = 0x06,
	CMDL_TUNERINIT   = 0x03,
	CMDL_BANDWIDTH   = 0x02,
	CMDL_LNBCONFIG   = 0x08,
	CMDL_LNBSEND 	= 0x0c,
	CMDL_SET_TONEPRE = 0x02,
	CMDL_SET_TONE	= 0x04,
	CMDL_TUNERSLEEP  = 0x02,
	CMDL_MAX     	= 0x00
};

/* Basic commands that are sent to the firmware */
struct ufs910_cmd
{
	enum cmds id;
	__u8 len;
	__u8 args[0x1e];
};


/* gibts da eigentlich keinen Header fuer??? */

struct i2c_msg 
{
	unsigned short addr;		/* slave address			*/
 	unsigned short flags;		
 	unsigned short len;		/* msg length				*/
 	unsigned char  *buf;		/* pointer to msg data			*/
};

//struct i2c_msg;

/* This is the structure as used in the I2C_RDWR ioctl call */
//struct i2c_rdwr_ioctl_data {
//	struct i2c_msg 	  	*msgs;	/* pointers to i2c_msgs */
//	unsigned int 	   	nmsgs;	/* number of i2c_msgs */
//};

#define TEST_MOUDLE     1
#define I2C_RDWR	0x0707	/* Combined R/W transfer (one stop only)*/


#define I2C_SLAVE_FORCE	0x0706	/* Change slave address			*/
				/* Attn.: Slave address is 7 or 10 bits */
				/* This changes the address, even if it */
				/* is already taken!			*/


int i2c_slave_force(int fd, char addr, char c1, char c2)
{
	char  buf[256];

	if(ioctl(fd, I2C_SLAVE_FORCE, addr) != 0)
	{
		printf("i2c failed 1\n");
		return -1;
	}

	buf[0] = c1;
	buf[1] = c2;
	if (write(fd, buf, 2) != 2)
	   return -2;
        return 0;
}

int i2c_slave_force_var(int fd, char addr, char* buffer, int len)
{
	if(ioctl(fd, I2C_SLAVE_FORCE, addr) != 0)
	{
		printf("i2c failed 1\n");
		return -1;
	}

	if (write(fd, buffer, len) != len)
	   return -2;
}

int i2c_readreg(int fd_i2c, char addr, char reg, char* value)
{
        int	result;
	struct 	i2c_rdwr_ioctl_data i2c_rdwr;

	/* */
	i2c_rdwr.nmsgs = 2;
	i2c_rdwr.msgs = malloc(2 * 32);
	i2c_rdwr.msgs[0].addr = addr;
	i2c_rdwr.msgs[0].flags = 0;
	i2c_rdwr.msgs[0].len = 1;
	i2c_rdwr.msgs[0].buf = malloc(1);
	i2c_rdwr.msgs[0].buf[0] = reg;

	i2c_rdwr.msgs[1].addr = addr;
	i2c_rdwr.msgs[1].flags = 1;
	i2c_rdwr.msgs[1].len = 1;
	i2c_rdwr.msgs[1].buf = malloc(1);
	i2c_rdwr.msgs[1].buf[0] = 0x00;
        result = ioctl(fd_i2c, I2C_RDWR, &i2c_rdwr);
        printf("%d\n",result);
	if(result < 0)
	{
		printf("i2c_readreg failed\n");

		free(i2c_rdwr.msgs[0].buf);
		free(i2c_rdwr.msgs[1].buf);

		return -1;
	}

	printf("0x%x\n",  i2c_rdwr.msgs[0].buf[0]);
	printf("0x%x\n",  i2c_rdwr.msgs[1].buf[0]);

	*value = i2c_rdwr.msgs[1].buf[0];
	
	free(i2c_rdwr.msgs[0].buf);
	free(i2c_rdwr.msgs[1].buf);

	return 0;
}

/* ********************************************* 
 * tuner_read_status				 
 * ********************************************* 
 */
int tuner_read_status(int fd_i2c, int* status)
{
	unsigned char lock;

	*status = 0;

	if (i2c_readreg(fd_i2c, 0x05, 0x9d, &lock) != 0)
	   return -1;

/* FIXME: FE_xy müssen noch definiert werden */
	if (lock & 0x01)
		*status |= FE_HAS_SIGNAL;
	if (lock & 0x02)
		*status |= FE_HAS_CARRIER;
	if (lock & 0x04)
		*status |= FE_HAS_VITERBI;
	if (lock & 0x08)
		*status |= FE_HAS_SYNC | FE_HAS_LOCK;

	return 0;
}
int tuner_wait_for_diseqc(int fd_i2c)
{
	int n;

	for(n = 0;n < 50; n++) 
    	{
	   unsigned char res;

	   if (i2c_readreg(fd_i2c, 0x05, 0xbc, &res) == 0)
	   {
		if (res & 0x20)
		  return 0;

		usleep(10000);
	   } else
	  	return -1;
	}

	printf("tuner_wait_for_diseqc: Timeout\n");
	return -1;
}

/* ************************************* 
 * tuner_cmd_execute 
 * ************************************* 
 */

int tuner_cmd_execute(int fd_i2c, struct ufs910_cmd *cmd)
{
	unsigned int i;
	unsigned char ret;

        if(cmd->id == CMD_SET_VCO)
            cmd->len = CMDL_SET_VCO;
        if(cmd->id == CMD_TUNEREQUEST)
            cmd->len = CMDL_TUNEREQUEST;
        if(cmd->id == CMD_MPEGCONFIG)
            cmd->len = CMDL_MPEGCONFIG;
        if(cmd->id == CMD_TUNERINIT)
            cmd->len = CMDL_TUNERINIT;
        if(cmd->id == CMD_BANDWIDTH)
            cmd->len = CMDL_BANDWIDTH;
        if(cmd->id == CMD_TUNERSLEEP)
            cmd->len = CMDL_TUNERSLEEP;
        if(cmd->id == CMD_LNBCONFIG)
            cmd->len = CMDL_LNBCONFIG;
        if(cmd->id == CMD_LNBSEND)
            cmd->len = CMDL_LNBSEND;
        if(cmd->id == CMD_SET_TONEPRE)
            cmd->len = CMDL_SET_TONEPRE;
        if(cmd->id == CMD_SET_TONE)
            cmd->len = CMDL_SET_TONE;
        if(cmd->id == CMD_MAX)
            return -EINVAL;

//	for(i = 0; i < 13; i++ )
//	{
//		if(ufs910_COMMANDS[i].id == CMD_MAX)
//			return -EINVAL;
//
//		if(ufs910_COMMANDS[i].id == cmd->id)
//		{
//			cmd->len = ufs910_COMMANDS[i].len;
//			break;
//		}
//	}

	cmd->args[0x00] = cmd->id;

	/* Write the command */
	for(i = 0; i < 0x1f/*cmd->len*/ ; i++)
	{
		if (i<cmd->len) 
		{
		   i2c_slave_force(fd_i2c, 0x05, i, cmd->args[i]);
		}
		else 
		   i2c_slave_force(fd_i2c, 0x05, i, 0);
	}

	/* Start execution and wait for cmd to terminate */
	i2c_slave_force(fd_i2c, 0x05, 0x1f, 0x01);

	i2c_readreg(fd_i2c, 0x05, 0x1f, &ret);

	while( ret )
	{
		i2c_readreg(fd_i2c, 0x05, 0x1f, &ret);
		usleep(10000);
		if(i++ > 128)
		{
			/* Avoid looping forever if the firmware does no respond */
			printf("tuner_cmd_execute: Firmware not responding\n");
			return -EREMOTEIO;
		}
	}
	return 0;
}

/* ************************************* 
 * tuner_send_diseqc_msg 
 * ************************************* 
 */

static int tuner_send_diseqc_msg (int fd_i2c,  struct dvb_diseqc_master_cmd *m)
{
	struct ufs910_cmd cmd;
	int len= m->msg_len;
	int n,pos=0;
	int ret;

	if (tuner_wait_for_diseqc(fd_i2c))
		return -ETIMEDOUT;

	cmd.id=CMD_LNBSEND;
	cmd.args[1]=0;
	cmd.args[2]=2;
	cmd.args[3]=0;
	cmd.args[4]=0;
	cmd.args[5]=4;
	
	while(len > 0) 
    	{
		if ( len > 6) 
		{
			cmd.args[4]=1; // Long message
			cmd.args[5]=6;
		}
		else 
 		{
			cmd.args[4]=0;
			cmd.args[5]=len;
		}

		for( n = 0; n < 6; n++)
		   cmd.args[6 + n] = m->msg[ pos + n];

		ret = tuner_cmd_execute(fd_i2c, &cmd);
		if (ret != 0)
		   return ret;
		pos += 6;
		len = len - 6;
	}

	return 0;
}

/* ************************************* 
 * tuner_send_diseqc_burst 
 * ************************************* 
 */

// FIXME: Check if tone burst really works...
int tuner_send_diseqc_burst (int fd_i2c, fe_sec_mini_cmd_t burst)
{
	struct ufs910_cmd cmd;
	int ret;

	if (tuner_wait_for_diseqc(fd_i2c))
		return -ETIMEDOUT;

	cmd.id = CMD_LNBCONFIG;
	cmd.args[1]=/*0*/ 0x03;
	cmd.args[2]=/*0x10*/ 0x01;
	cmd.args[3]=/*0x00*/ 0x00;
	cmd.args[4]=0x8f;
	cmd.args[5]=0x28;
	cmd.args[6]=0x01; // enable burst
	cmd.args[7]=0x01;

	ret = tuner_cmd_execute(fd_i2c, &cmd);

	if (ret != 0)
		return ret;

	/* GA Hack: It's not possible to send a tone burst on its own 
	without a DiSeqC-message. So either we need to wait for a
	real message (depends on tuning client, IMO not reliable) or
	send a dummy message with all bits zero. So the framing
	nibble (0xE*) is missing and hopefully all devices ignore it.
	*/
		
   		cmd.id=CMD_LNBSEND;
	cmd.args[1] = burst == SEC_MINI_A ? 0x00 : 0x01;
	cmd.args[2] = 2;
	cmd.args[3] = 0;
	cmd.args[4] = 0;
	cmd.args[5] = 3; 	// Dummy 3 bytes
	cmd.args[6] = 0;
	cmd.args[7] = 0;
	cmd.args[8] = 0;

	ret = tuner_cmd_execute(0xfe, &cmd);

	cmd.id = CMD_LNBCONFIG;
	cmd.args[1]=/*0*/ 0x03;
	cmd.args[2]=/*0x10*/ 0x01;
	cmd.args[3]=/*0x00*/ 0x00;
	cmd.args[4]=0x8f;
	cmd.args[5]=0x28;
	cmd.args[6]=0x00; // disable burst
	cmd.args[7]=0x01;

	ret = tuner_cmd_execute(0xfe, &cmd);

	if (ret != 0)
		return ret;

	
	return ret;
}

/* ************************************* 
 * tuner_set_tone 
 * ************************************* 
 */

int tuner_set_tone(int fd_i2c, fe_sec_tone_mode_t tone)
{
	struct ufs910_cmd cmd;
	int ret;

	if ( (tone != SEC_TONE_ON) && (tone != SEC_TONE_OFF) ) 
    	{
		printf("tuner_set_tone: Invalid, tone=%d\n", tone);
		return -EINVAL;
	}
	/* wait for diseqc queue ready */
	tuner_wait_for_diseqc(fd_i2c);

	/* This is always done before the tone is set */
	cmd.id = CMD_SET_TONEPRE;
	cmd.args[0x01] = 0x00;
	ret = tuner_cmd_execute(fd_i2c, &cmd);
	if (ret != 0)
	   return ret;

	/* Now we set the tone */
	cmd.id = CMD_SET_TONE;
	cmd.args[0x01] = 0x00;
	cmd.args[0x02] = 0x00;

	switch (tone) 
    	{
	case SEC_TONE_ON:
		printf("tuner_set_tone: setting tone on\n");
		cmd.args[0x03] = 0x01;
		break;
	case SEC_TONE_OFF:
		printf("tuner_set_tone: setting tone off\n");
		cmd.args[0x03] = 0x00;
		break;
	}

	return tuner_cmd_execute(0xfe, &cmd);
}

#ifdef TEST_MOUDLE

int main(int argc, char* argv[])
{
	int vLoop;
        struct dvb_diseqc_master_cmd diseqc_cmd;
        int    fd, status;
	
   if (argc > 1)
	{
		for (vLoop = 1; vLoop < argc; vLoop++)
		 {
		 	printf("%d\n", atoi(argv[vLoop]));	 
		 }
	}

	
//	return 0;
//}
//void main(void)
//{
        
//	printf("test");
        fd = open("/dev/i2c-0", O_RDWR);
        printf("%d\n", tuner_read_status(fd, &status));
        printf("%d\n", status);
        
        diseqc_cmd.msg[0] = 0xE0;
        diseqc_cmd.msg[1] = 0x10;
        diseqc_cmd.msg[2] = atoi(argv[1]);
        diseqc_cmd.msg[3] = atoi(argv[2]);
        diseqc_cmd.msg_len    = 4;
	tuner_send_diseqc_msg (fd,  &diseqc_cmd);
}

#endif
