#!/bin/sh

STREAMDIR=/hdd
DAEMON=/bin/streamripper
ARGS="$2 -d $STREAMDIR"

test -f $DAEMON || exit 0

case "$1" in
    start)
	if [ ! -d $STREAMDIR ]; then
		echo "$STREAMDIR is missing."
		exit 1
	fi
	
	echo -n "starting streamripper... "
	start-stop-daemon -S -b -n streamripper -a $DAEMON -- $ARGS
	echo "done."
	;;
    stop)
	start-stop-daemon -K -n streamripper
	echo "done."
	;;
    *)
	echo "Usage: $0 {start|stop}"
	exit 1
	;;
esac

exit 0
