from enigma import Cbptools, Cbpconfig, Cbputils, eTimer, iPlayableService, gEvent, eListbox, eServiceReference, iServiceInformation, Chttp, eRCInput, getPrevAsciiCode

from BPtools import cleanexit, BPLoadPixmap, BpMenuSummary, DEFAULT_MVI, startPicplayer
from BPskin import Skin_dreamnetcast
from BPvariables import geventNotifier, TEMP_FILE, BPConfigSelection, BPConfigOnOff, CONFIGSEPERATOR, BPConfigDirectory, ConfigWindow
from BPdownload import DLMenu, DL_DREAMNETCAST

from Screens.Screen import Screen
from Screens.ChoiceBox import ChoiceBox
from Screens.MessageBox import MessageBox
from Screens.InputBox import InputBox
from Components.Input import Input
from Components.Sources.List import List
from Components.Sources.StaticText import StaticText
from Components.ActionMap import NumberActionMap
from Components.Label import Label
from Components.Button import Button
from Components.Pixmap import Pixmap
from Components.ServiceEventTracker import ServiceEventTracker
from Components.config import config, NoSave, getConfigListEntry

from Tools.LoadPixmap import LoadPixmap
from Tools.Directories import resolveFilename, SCOPE_SKIN_IMAGE
from Tools.NumericalTextInput import NumericalTextInput

from time import strftime, localtime, time as getTime

#-------------------------------------------------------------------------
#----insert AOL key here ------#
AOL_Dev_key = "xxxxxxxxxxxxxxxx"
#------------------------------#
FAVORITENFILE = "/etc/favo_netcast.xml"
NETCAST_URL = "http://api.shoutcast.com"
STREAMRIPPER = "streamripper"
STREAMRIPPERDEBUG = "/tmp/.streamdebug"
PlayIcon = LoadPixmap(resolveFilename(SCOPE_SKIN_IMAGE, "skin_default/icons/ico_mp_play.png"))
StopIcon = LoadPixmap(resolveFilename(SCOPE_SKIN_IMAGE, "skin_default/icons/ico_mp_stop.png"))

#playlisten
PL_FAVO = 0
PL_TOP = 1
PL_GENRE = 2
PL_SEARCH = 3

#Inhalt
INDEX = 0
TYPE = 1
NAME = 2
URL = 3
ID = 4
BR = 5
GENRE = 6
BASE = 7

#sortieren
S_INDEX = 0
S_BITRATE = 1
S_NAME = 2

#-------------------------------------------------------------------------

class dreamnetcast(Screen):
	def __init__(self, session, name=""):
		self.skin = Skin_dreamnetcast
		Screen.__init__(self, session)
		
		self.numericalTextInput = NumericalTextInput()
		self.numericalTextInput.setUseableChars(u'1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZ')
		
		self["actions"] = NumberActionMap(["BPActions", "NumberActions", "InputAsciiActions"],
		{
			"up": self.KeyUp,
			"down": self.KeyDown,
			"left": self.KeyLeft,
			"right": self.KeyRight,
			"ok": self.KeyOK,
			"exit": self.Exit,
			"red": self.KeyRed,
			"green": self.KeyGreen,
			"yellow": self.KeyYellow,
			"blue": self.KeyBlue,
			"menu": self.KeyMenu,
			"info": self.KeyInfo,
			"stop": self.KeyStop,
			"gotAsciiCode": self.KeyAsciiCode,
			"1": self.KeyNumberGlobal,
			"2": self.KeyNumberGlobal,
			"3": self.KeyNumberGlobal,
			"4": self.KeyNumberGlobal,
			"5": self.KeyNumberGlobal,
			"6": self.KeyNumberGlobal,
			"7": self.KeyNumberGlobal,
			"8": self.KeyNumberGlobal,
			"9": self.KeyNumberGlobal,
			"0": self.KeyNumber0
		}, -1)
		
		self["key_red"] = Button(_("Sort"))
		self["key_green"] = Button(_("Top List"))
		self["key_yellow"] = Button(_("Genre List"))
		self["key_blue"] = Button(_("Favourites"))
		self["menu"] = List([])
		self["label0"] = Label()
		self["label1"] = Label()
		self["label2"] = Label()
		self["status_pic"] = Pixmap()
		self["rec_pic"] = Pixmap()
		self["info_pic"] = Pixmap()
		self["title"] = StaticText()
		
		self.playlisten = [[],[],[],[]]
		self.lastsearchstr = ""
		self.lastitem = []
		self.sort = S_INDEX
		self.writeNewFavoXML = False
		self.lastservice = session.nav.getCurrentlyPlayingServiceReference()
		self.session.nav.stopService()
		
		self.HideTimer = eTimer()
		self.HideTimer.callback.append(self.setHide)

		self.httpPL = Chttp()
		self.httpPL.finish.get().append(self.__loadPLCallback)

		self.onLayoutFinish.append(self.__LayoutFinish)
		geventNotifier.append((gEvent.G_EVENT, self.__newSRstatus))
		
		self.__event_tracker = ServiceEventTracker(screen=self, eventmap=
			{
				iPlayableService.evUpdatedInfo: self.__evUpdatedInfo,
				iPlayableService.evStart: self.__serviceStarted,
				iPlayableService.evEnd: self.__serviceStopped,
				iPlayableService.evUser+10: self.__evAudioDecodeError,
			})
		rcinput = eRCInput.getInstance()
		rcinput.setKeyboardMode(rcinput.kmAscii)
		self.onClose.append(self.__onClose)

	def __onClose(self):
		rcinput = eRCInput.getInstance()
		rcinput.setKeyboardMode(rcinput.kmNone)
		self.session.nav.playService(self.lastservice)

	def __LayoutFinish(self):
		self.__readconfig(True)
		self.__newSRstatus()
		self.KeyBlue()
		
	def Exit(self):
		geventNotifier.remove((gEvent.G_EVENT, self.__newSRstatus))
		
		if self.writeNewFavoXML == True:
			writeFavoFile(self.playlisten[PL_FAVO])

		if Cbptools.getInstance().event_state & Cbptools.E_STREAMRIPPER:
			tmpstr = "Streamripper " + _("working in Background") + "\n" + _("Stop recording")
			self.session.openWithCallback(self.__ExitTrue, MessageBox, tmpstr, MessageBox.TYPE_YESNO, default=False)
		else:
			self.__ExitTrue()

	def __ExitTrue(self, val = None):
		if val == True:
			self.__StopStreamripper()
		del self.httpPL
		self.close(None)
		cleanexit(__name__)

	def createSummary(self):
		return BpMenuSummary
		
	def __evAudioDecodeError(self):
		currPlay = self.session.nav.getCurrentService()
		sTagAudioCodec = currPlay.info().getInfoString(iServiceInformation.sTagAudioCodec)
		self.session.open(MessageBox, _("This Dreambox can't decode %s streams!") % sTagAudioCodec, type = MessageBox.TYPE_INFO,timeout = 20 )
		
	def __serviceStarted(self):
		self["status_pic"].instance.setPixmap(PlayIcon)
		
	def __serviceStopped(self):
		self["status_pic"].instance.setPixmap(StopIcon)

	def __evUpdatedInfo(self):
		currPlay = self.session.nav.getCurrentService()
		info0 = ""
		info1 = ""
		info2 = ""
		if currPlay is not None:
			info0 = _("Title") + ": " + currPlay.info().getInfoString(iServiceInformation.sTagTitle)
			info1 = _("Station") + ": " + self.lastitem[NAME]
			if self.lastitem[BR] > 0:
				info2 = _("Bitrate") + ": " + str(self.lastitem[BR]) + " kbps       "
			info2 += "Codec: " + currPlay.info().getInfoString(iServiceInformation.sTagAudioCodec)
		self.__setLabels(info0, info1, info2)

	def __setLabels(self, t1, t2, t3):
		self["label0"].setText(t1)
		self["label1"].setText(t2)
		self["label2"].setText(t3)

	def __newSRstatus(self,val=0):
		if Cbptools.getInstance().event_state & Cbptools.E_STREAMRIPPER:
			self["rec_pic"].show()
			self["info_pic"].show()
		else:
			self["rec_pic"].hide()
			self["info_pic"].hide()	
	
	def __fillList(self):
		flist = []
		
		sortby = INDEX
		reverse=False
		if self.sort == S_BITRATE:
			sortby = BR
			reverse=True
		if self.sort == S_NAME:
			sortby = NAME
		
		if self.listsel == PL_FAVO:
			tmplist = self.playlisten[self.listsel]
		else:
			tmplist = sorted(self.playlisten[self.listsel], key=lambda x: x[sortby], reverse=reverse)
		
		for x in tmplist:
			tmpstr = ""
			if self.listsel != PL_FAVO:
				tmpstr = " (" + str(x[INDEX]) + ")  "
			tmpstr += x[NAME] + "\n"
			#print x
			pic = "none.png"
			if x[TYPE] == 1:
				pic = "music.png"
				if x[URL] != "":
					tmpstr += x[URL]
				if x[BR]>0:
					tmpstr += _("Bitrate") + ":  " + str(x[BR]) + " kbps\t"
				if x[GENRE] != "":
					tmpstr += _("Genre")  + ":  " + x[GENRE]
			
			flist.append((tmpstr, BPLoadPixmap("extra_icons/" + pic), "" , x))
		
		self["menu"].list = flist
		self.__updateTitle()

	def __getNextBeginningWithChar(self,char):
		idx = 0
		for i in self["menu"].list:
			if i[3][NAME][0] == char:
				self["menu"].setIndex(idx)
				break
			idx += 1

	def KeyStop(self):
		self.__HideShow()
		self.session.nav.stopService()

	def KeyDown(self):
		self.__HideShow()
		self["menu"].selectNext()

	def KeyUp(self):
		self.__HideShow()
		self["menu"].selectPrevious()
		
	def KeyLeft(self):
		self.__HideShow()
		self["menu"].move_to(eListbox.pageUp)

	def KeyRight(self):
		self.__HideShow()
		self["menu"].move_to(eListbox.pageDown)

	def KeyRed(self): #sortieren
		self.__HideShow()
		self.sort += 1
		if self.sort > S_NAME:
			self.sort = S_INDEX
		self.__fillList()

	def KeyGreen(self): #Top liste
		self.__HideShow()
		self.listsel = PL_TOP
		if len(self.playlisten[self.listsel])<1 or self.list_reload==1:
			self.session.openWithCallback(self.__loadXML, DLMenu, "http://api.shoutcast.com/legacy/Top500?k=" + AOL_Dev_key + "&limit=50", TEMP_FILE, "", _("Top List"))
		else:
			self.__fillList()

	def KeyYellow(self): #Genre liste
		self.__HideShow()
		self.listsel = PL_GENRE
		if len(self.playlisten[self.listsel])<1 or self.list_reload==1:
			self.session.openWithCallback(self.__loadXML, DLMenu, "http://api.shoutcast.com/legacy/genrelist?k=" + AOL_Dev_key, TEMP_FILE, "", _("Genre List"))
		else:
			self.__fillList()

	def KeyBlue(self): # Favo Liste
		self.__HideShow()
		self.listsel = PL_FAVO
		if len(self.playlisten[self.listsel])<1 or self.list_reload==1:
			self.__loadXML(0, FAVORITENFILE)
		else:
			self.__fillList()

	def KeyInfo(self):
		self.__HideShow()
		if Cbptools.getInstance().event_state & Cbptools.E_STREAMRIPPER:
			Cbputils.gSystem("killall -SIGUSR1 " + STREAMRIPPER + " & sleep 2")
			tmpstr = readDebugFile()
			if tmpstr is not None:
				self.session.open(MessageBox, tmpstr , MessageBox.TYPE_INFO)

	def KeyOK(self):
		self.__HideShow()
		sel = self["menu"].getCurrent()
		if sel and sel[3]:
			val = sel[3]
			if val[TYPE] == 0:
				self.lastsearchstr = val[NAME]
				self.listsel = PL_SEARCH
				url = "http://api.shoutcast.com/legacy/stationsearch?k=" + AOL_Dev_key + "&search=" + self.lastsearchstr
				self.session.openWithCallback(self.__loadXML, DLMenu, url, TEMP_FILE, "", "Dreamnetcast")
			else:
				if val[URL] != "":
					self.lastitem = list(val)
					self.__playURL()
				elif val[ID] != "" and val[BASE] != "":
					self.lastitem = list(val)
					self.httpPL.startDownload("http://yp.shoutcast.com/sbin/tunein-station.pls?id=" + val[ID]+ "&k=" + AOL_Dev_key, TEMP_FILE, None, DL_DREAMNETCAST)
					self.__setLabels("", _("Please wait..."),"")

	def KeyNumberGlobal(self, number):
		unichar = self.numericalTextInput.getKey(number)
		charstr = unichar.encode("utf-8")
		if len(charstr) == 1:
			self.__getNextBeginningWithChar(charstr[0])

	def KeyAsciiCode(self):
		unichar = unichr(getPrevAsciiCode())
		charstr = unichar.encode("utf-8")
		if len(charstr) == 1:
			if charstr[0] == "0":
				self["menu"].setIndex(0)
			self.__getNextBeginningWithChar(charstr[0].upper())
			
	def KeyNumber0(self, num):
		self["menu"].setIndex(0)
		self.KeyNumberGlobal(num)

	def KeyMenu(self):
		self.__HideShow()
		menu = []
		menu.append((_("Search"), 2))
		if Cbptools.getInstance().event_state & Cbptools.E_STREAMRIPPER:
			menu.append((_("Stop recording"), 3))
		else:
			if self.session.nav.getCurrentlyPlayingServiceReference() is not None:
				menu.append((_("Start recording?"), 4))
		if self.session.nav.getCurrentlyPlayingServiceReference() is not None or self.listsel == PL_GENRE:
			menu.append((_("Add to favourites"), 5))
		if self.listsel == PL_FAVO:
			menu.append((_("Delete Favourites") + " " + _("entrys"), 6))
		menu.append(("--", ""))
		menu.append((_("Setup"), 1))
		if self.session.nav.getCurrentlyPlayingServiceReference() is not None:
			menu.append((_("Start") + " " + _("PicturePlayer"), 7))
		self.session.openWithCallback(self.__menuCallback, ChoiceBox, title="", list=menu, skin_name = "ChoiceBox_dreamnetcast")
	
	def __menuCallback(self, choice = None):
		if choice is None:
			return

		if choice[1] == 1:#setup
			self.session.openWithCallback(self.__readconfig, NetcastSetup)
		elif choice[1] == 2:#suchen
			self.search = Cbpconfig.getInstance().getParaStr("netcast_last_search_str")
			if self.search == "":
				self.search = "disco"
			self.session.openWithCallback(self.__searchCallback, InputBox, title=_("Please enter a name for search"), text=self.search, maxSize=False, type=Input.TEXT)
		elif choice[1] == 6:#Favo loeschen
			sel = self["menu"].getCurrent()
			if sel and sel[3]:
				index = self.playlisten[PL_FAVO].index(sel[3])
				self.playlisten[PL_FAVO].pop(index)
				self.writeNewFavoXML = True
				self.__fillList()
		elif choice[1] == 5:#Favo hinzufuegen
			if self.listsel == PL_GENRE:
				sel = self["menu"].getCurrent()
				if sel and sel[3]:
					self.playlisten[PL_FAVO].append(sel[3])
					self.writeNewFavoXML = True
			elif self.session.nav.getCurrentlyPlayingServiceReference() is not None:
				self.playlisten[PL_FAVO].append(self.lastitem)
				self.writeNewFavoXML = True
		elif choice[1] == 4: #Aufnahme starten
			tmpstr = _("Start recording?") + "\n\n" + _("Record Location") + ":\n" + self.sr_dir
			tmpstr += "\n" + _("free") + " " + Cbputils.gHuman_String(Cbputils.gFreeSize(self.sr_dir)) + "\n\n"
			if self.sr_const_stream == 1:
				tmpstr += _("Recording as a continuous stream")
			else:
				tmpstr += _("Recording as an individual title")
			self.session.openWithCallback(self.__StartStreamripper, MessageBox, tmpstr, MessageBox.TYPE_YESNO)
		elif choice[1] == 3:#Aufnahme stoppen
			self.__StopStreamripper()
		elif choice[1] == 7:#Picplayer starten
			startPicplayer(self.session)
	
	def __searchCallback(self, val = None):
		if val != None:
			Cbpconfig.getInstance().setParaStr("netcast_last_search_str", val)
			self.lastsearchstr = val
			self.listsel = PL_SEARCH
			url = "http://api.shoutcast.com/legacy/stationsearch?k=" + AOL_Dev_key + "&search=" + self.lastsearchstr
			self.session.openWithCallback(self.__loadXML, DLMenu, url, TEMP_FILE, name="Dreamnetcast")

	def __readconfig(self, val=False):
		if val == True:
			self.bitrate = Cbpconfig.getInstance().getParaInt("netcast_bitrate")
			self.list_reload = Cbpconfig.getInstance().getParaInt("netcast_list_reload")
			self.sr_dir = Cbpconfig.getInstance().getParaStr("netcast_sr_dir","/media/hdd")
			self.sr_const_stream = Cbpconfig.getInstance().getParaInt("netcast_const_stream")
			self.hide_dnc = Cbpconfig.getInstance().getParaInt("netcast_hide")
			self.tv_ton_by_stop = Cbpconfig.getInstance().getParaInt("netcast_tv_ton")
			self.__HideShow()
			Cbputils.gSystem("/usr/bin/showiframe '" + Cbpconfig.getInstance().getParaStr("netcast_backgroundmvi", DEFAULT_MVI) + "'")

	def __loadPLCallback(self, code=0, streamurl=""):
		self.__setLabels("","","")
		if code == 0 and streamurl != "":
			self.lastitem[URL] = streamurl
			self.__playURL()

	def __loadXML(self, download=0, file=""):
		if download == 1:
			file = TEMP_FILE
		if file != "":
			self.playlisten[self.listsel] = Cbptools.getInstance().CamdCommandPY(Cbptools.NETCAST, file, self.bitrate)
			Cbputils.gDelete(TEMP_FILE)
		else:
			self.playlisten[self.listsel] = []
		self.__fillList()

	def __HideShow(self):
		self.HideTimer.stop()
		if self.hide_dnc <= 0:
			return
		print "start HideTimer ", self.hide_dnc
		self.HideTimer.start(self.hide_dnc*1000, True)
		self.show()

	def setHide(self):
		if self.shown:
			self.hide()

	def __updateTitle(self):
		tmpstr = ""
		if self.listsel == PL_FAVO:
			tmpstr += _("Favourites")
		if self.listsel == PL_GENRE:
			tmpstr += _("Genre List")
		if self.listsel == PL_TOP:
			tmpstr += _("Top List")
		if self.listsel == PL_SEARCH:
			tmpstr +=  _("Searching for") + " " + self.lastsearchstr
		tmpstr += " (" + str(len(self.playlisten[self.listsel])) +  ")"

		sortstr = _("Index")
		if self.sort == S_BITRATE:
			sortstr = _("Bitrate")
		if self.sort == S_NAME:
			sortstr = _("Name")

		self["key_red"].setText(sortstr)
		self["title"].setText(tmpstr)
		self.setTitle(tmpstr)

	def __playURL(self):
		if self.lastitem[URL] != "":
			self.session.nav.stopService()
			self.session.nav.playService(eServiceReference(4097, 0, self.lastitem[URL]))

	def __StartStreamripper(self, val = None):
		if val == True:
			cmd = STREAMRIPPER + " '" + self.lastitem[URL] + "' "
			if self.sr_const_stream == 1:
				file = self.sr_dir + "/" + self.lastitem[NAME] + strftime("_%d%m%Y_%H%M", localtime(getTime()))
				cmd += "-A --xs_none --xs_silence_length=0 -a '" + file + "' &"
			else:
				cmd += "-d '" + self.sr_dir + "' &"
			#print "________start " + cmd
			Cbputils.send2gDaemon(cmd)
			
	def __StopStreamripper(self):
		tmp = _("One moment please...") + "\nStreamripper " + _("becomes terminates") + "\n" + _("That can last some time\n")
		self.session.open(MessageBox, tmp, MessageBox.TYPE_INFO, timeout=4)
		Cbputils.gSystem("killall -SIGTERM " + STREAMRIPPER)

#-------------------------------------------------------------------------

class NetcastSetup(ConfigWindow):
	def __init__(self, session):
		ConfigWindow.__init__(self, session, greenbutton=_("Save"))

		menu = [("0", _("none"))]
		for x in range(1,10):
			menu.append((str((x)*64), str(x*64) + " kbps"))
		config.bp.val0 = NoSave(BPConfigSelection(default=str(Cbpconfig.getInstance().getParaInt("netcast_bitrate")), choices=menu))
		config.bp.val1 = NoSave(BPConfigOnOff(default=Cbpconfig.getInstance().getParaInt("netcast_list_reload")))
		config.bp.val2 = NoSave(BPConfigDirectory(default=Cbpconfig.getInstance().getParaStr("netcast_sr_dir", "/media/hdd"), visible_width=35))
		config.bp.stream = NoSave(BPConfigOnOff(default=Cbpconfig.getInstance().getParaInt("netcast_const_stream")))
		
		menu = [("0", _("off"))]
		for x in range(1,13):
			menu.append((str(x*5), str(x*5) + " Second(s)"))

		config.bp.val3 = NoSave(BPConfigSelection(default=str(Cbpconfig.getInstance().getParaInt("netcast_hide")), choices=menu))
		
		config.bp.val4 = NoSave(BPConfigDirectory(default=Cbpconfig.getInstance().getParaStr("netcast_backgroundmvi", DEFAULT_MVI), visible_width=35, filt=Cbputils.FILTER_MVI))
		
		list = []
		list.append(getConfigListEntry(_("Minimum Bitrate"), config.bp.val0))
		list.append(getConfigListEntry(_("Lists always reload"), config.bp.val1))
		list.append(CONFIGSEPERATOR)
		list.append(getConfigListEntry(_("Streamripper") + " " + _("record directory"), config.bp.val2))
		list.append(getConfigListEntry(_("Streamripper") + " " + _("constant stream"), config.bp.stream))
		list.append(CONFIGSEPERATOR)
		list.append(getConfigListEntry(_("Hide Dreamnetcast after"), config.bp.val3))
		list.append(getConfigListEntry(_("Background") + " (MVI)", config.bp.val4))
		self.SetConfList(list)
		
	def KeyGreen(self):
		Cbpconfig.getInstance().setParaInt("netcast_bitrate", int(config.bp.val0.value))
		Cbpconfig.getInstance().setParaInt("netcast_list_reload", config.bp.val1.value)
		Cbpconfig.getInstance().setParaStr("netcast_sr_dir", config.bp.val2.value)
		Cbpconfig.getInstance().setParaInt("netcast_const_stream", config.bp.stream.value)
		Cbpconfig.getInstance().setParaInt("netcast_hide", int(config.bp.val3.value))
		Cbpconfig.getInstance().setParaStr("netcast_backgroundmvi", config.bp.val4.value)
		self.Exit()
	
	def Exit(self):
		self.close(self.ListChanged())

#-------------------------------------------------------------------------

def readDebugFile():
	try:
		tmpstr = ""
		file = open(STREAMRIPPERDEBUG, 'r')
		lines = file.readlines()
		file.close()
		for x in lines:
			tmpstr += x
		Cbputils.gDelete(STREAMRIPPERDEBUG)
		return tmpstr
	except:
		return None

def writeFavoFile(liste):
	try:
		from Tools.XMLTools import stringToXML
		wfile = open(FAVORITENFILE, 'w')
		wfile.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>" + '\n\n')
		wfile.write("<genrelist>\n")
		for x in liste:
			if x[NAME] != "" and x[URL] != "":
				wfile.write("\t<genre name=\"%s\" url=\"%s\" ></genre>\n" %(stringToXML(x[NAME]), x[URL]))
			elif x[NAME] != "":
				wfile.write("\t<genre name=\"%s\" ></genre>\n" %(stringToXML(x[NAME])))
		wfile.write("</genrelist>\n")
		wfile.close()
	except:
		pass
